<?php
/*
 * Clients Shortcode
 * Author: FOXTHEMES
 * Author URI: http://foxthemes.com
 * Version: 1.0.0 
 */
if (function_exists('vc_map')) {
	vc_map( 
		array(
			'name'						=> esc_html__( 'Clients', 'js_composer' ),
			'base'						=> 'vc_clients',
			'content_element'			=> true,
			'show_settings_on_create'	=> true,
			'description'				=> esc_html__( '', 'js_composer'),
			'params'					=> array ( 
				array (
					'param_name' => 'image',
					'type' => 'attach_image',
					'description' => '',
					'heading' => 'Image',
					'value' => '',
				), 
				array (
					'param_name' => 'link',
					'type' => 'vc_link',
					'description' => '',
					'heading' => 'Link',
					'value' => '',
				), 
				array (
					'type' => 'textfield',
					'heading' => 'Extra class name',
					'param_name' => 'el_class',
					'description' => 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.',
					'value' => '',
				), 
				array (
					'type' => 'css_editor',
					'heading' => 'CSS box',
					'param_name' => 'css',
					'group' => 'Design options',
				),
			)
			//end params
		) 
	);
}
if (class_exists('WPBakeryShortCode')) {
	/* Frontend Output Shortcode */
	class WPBakeryShortCode_vc_clients extends WPBakeryShortCode {
		protected function content( $atts, $content = null ) {
			/* get all params */
			extract( shortcode_atts( array(
				'image'	=> '',
				'link'	=> '',
				'el_class'	=> '',
				'css'	=> '',
			
			), $atts ) );

			$css_classes = array(
				$this->getExtraClass( $el_class )
			);
			$wrap_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( $css_classes ) ), $this->settings['base'], $atts );

			/* get param class */
			$wrap_class  = !empty( $el_class ) ? $el_class : '';
			/* get custum css as class*/
			$wrap_class .= vc_shortcode_custom_css_class( $css, ' ' );
			
			// start output
			ob_start(); ?>
			<div class="prague-clients-wrapper <?php echo esc_attr( $wrap_class ); ?>">
				<?php if(!empty($image) ):?>
					<?php
					$image_src = wp_get_attachment_image_src( $image, 'full' );
					$image_src = is_array($image_src) ? $image_src[0] : $image_src; ?>
					<img class="prague-clients-logo" src="<?php echo esc_url($image_src );?>"  alt="<?php echo get_post_meta( $image, '_wp_attachment_image_alt', true); ?>">
				<?php endif; ?>
				<div class="prague-clients-overlay"></div>
				<?php if(!empty($link)) { 

					$vc_link = vc_build_link( $link ); 

					$target = ''; 
					if ( !empty( $vc_link['target'] ) ) { 	
						$target = ' target="' . esc_attr( trim($vc_link['target']) ) . '"'; 
					} 

					$rel = '';
					if ( !empty( $vc_link['rel'] ) ) { 	
						$rel = ' rel="' . esc_attr( trim($vc_link['rel']) ) . '"'; 
					} 
					
					if (!empty($vc_link['url'])) { 

						if ( empty($vc_link['title'])) {
							$vc_link['title'] = 'label';
						}
						?>
						<div class="vertical-align prague-clients-link">
							<a href="<?php echo esc_url($vc_link['url']) ?>" class="prague-clients-name a-btn-arrow" <?php echo $target; ?> <?php echo $rel; ?>>
									<?php echo esc_html( $vc_link['title'] ); ?>
								<span class="arrow-right grey"></span>
							</a>
						</div>
					<?php }
				} ?>
			</div>
			<?php
			// end output
			return ob_get_clean();
		}
	}
}
